(function() {
  //    FILE:EventListView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 5/15/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/contact/ContactModel', 'models/objects/ObjectModel', "collections/event/EventCollection", "views/event/EventListView", 'views/contact/CompanyView', 'views/contact/FormContactView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, ContactModel, ObjectModel, EventCollection, EventListView, CompanyView, FormContactView) {
    var ContactView;
    return ContactView = class ContactView extends Backbone.View {
      initialize(usr, contact1, contactsCol) {
        this.usr = usr;
        this.contact = contact1;
        this.contactsCol = contactsCol;
        //#console.log 'Contact View Init '+@contact.get('firstName')
        this.contact.on('change', this.update_details, this);
        this.contact.on('change', this.update_note, this);
        return this.contact.on('change', this.update_customfields, this);
      }

      attributes() {
        return {
          'data-role': 'page'
        };
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-btn-company': 'btnCompanyClicked',
          'tap .btn-submenu-contact': 'subMenuContactClicked',
          'tap #id-btn-relatedEvents': 'btnRelatedEventsClicked',
          'tap #id-btn-edit-contact': 'btnEditContactClicked'
        };
      }

      render() {
        var ref, template;
        template = Handlebars.templates['ContactView'];
        this.$el.html(template({
          usr: this.usr.toJSON(),
          contact: this.contact.toJSON(),
          canViewRelatedEvents: this.usr.__can_view_related_events_to_contact(),
          isReadonly: (ref = this.contact.get('Contact')) != null ? ref.isReadonly : void 0
        }));
        this.addSidePanel();
        return this.$el.attr('id', 'id-ContactView');
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      subMenuContactClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        $('.subContactView').hide();
        return $(id).show();
      }

      update_details(mdl) {
        var add, contact, contactID, em, hideUserNumber, ph, url, www;
        this.$el.find('#id-spinner-all').hide();
        contact = mdl.get('Contact');
        //EDIT BUTTON
        if (!contact.isReadonly) {
          this.$el.find('#id-btn-edit-contact').show();
        }
        //HEADER SECTION
        $('#id-header-contactName > span.name').text(contact.firstName + ' ' + contact.lastName);
        $('#id-header-contactName > span.title').text(contact.title);
        $('#id-header-contactName').attr('data-contactID', contact.contactID);
        //BUTTON COMPANY
        if (contact.companyName) {
          $('#id-btn-company .ui-btn-text').html(contact.companyName + '<br>' + contact.category);
          $('#id-btn-company').attr('data-companyID', contact.companyID);
          $('#id-btn-company').show();
        } else {
          $('#id-btn-company').hide();
        }
        $('#id-p-type').text(contact.type);
        //EMAIL / WWW / OTHER
        if (contact.email) {
          em = '<a href="mailto:' + contact.email + '">' + contact.email + '</a>';
          $('#id-p-email').html(em);
          $('#id-div-email-info').show();
        } else {
          $('#id-div-email-info').hide();
        }
        if (contact.www) {
          url = _.indexOf(contact.www, 'http') !== -1 ? contact.www : "http://" + contact.www;
          www = '<a href="' + url + '" target="_blank">' + contact.www + '</a>';
          $('#id-p-www').html(www);
          $('#id-div-www-info').show();
        } else {
          $('#id-div-www-info').hide();
        }
        hideUserNumber = this.usr.get('hideUserNumber');
        if (contact.other && !hideUserNumber) {
          $('#id-p-other').text(contact.other);
          $('#id-div-other-info').show();
        } else {
          $('#id-div-other-info').hide();
        }
        //HOMEPHONE DIRECT MOBILE FAX
        if (contact.phoneHome) {
          ph = '<a href="tel:' + contact.phoneHome + '">' + contact.phoneHome + '</a>';
          $('#id-p-phoneHome').html(ph);
          $('#id-div-phoneHome-info').show();
        } else {
          $('#id-div-phoneHome-info').hide();
        }
        if (contact.phoneWork) {
          ph = '<a href="tel:' + contact.phoneWork + '">' + contact.phoneWork + '</a>';
          $('#id-p-phoneWork').html(ph);
          $('#id-div-phoneWork-info').show();
        } else {
          $('#id-div-phoneWork-info').hide();
        }
        if (contact.phoneDirect) {
          ph = '<a href="tel:' + contact.phoneDirect + '">' + contact.phoneDirect + '</a>';
          $('#id-p-phoneDirect').html(ph);
          $('#id-div-phoneDirect-info').show();
        } else {
          $('#id-div-phoneDirect-info').hide();
        }
        if (contact.phoneMobile) {
          ph = '<a href="tel:' + contact.phoneMobile + '">' + contact.phoneMobile + '</a>';
          $('#id-p-phoneMobile').html(ph);
          $('#id-div-phoneMobile-info').show();
        } else {
          $('#id-div-phoneMobile-info').hide();
        }
        if (contact.fax) {
          $('#id-p-fax').text(contact.fax);
          $('#id-div-fax-info').show();
        } else {
          $('#id-div-fax-info').hide();
        }
        //ADDRESS / NOTE
        if (contact.address) {
          add = '<a href="http://maps.google.com/maps?q=' + encodeURIComponent(contact.address) + '" target="_blank">' + contact.address + '</a>';
          $('#id-p-address').html(add);
          $('#id-div-address-info').show();
        } else {
          $('#id-div-address-info').hide();
        }
        //BUTTON TO RELATED EVENT
        contactID = "releatedToContact:" + contact.contactID;
        return $('#id-btn-relatedEvents').attr('data-objectID', contactID);
      }

      update_customfields(mdl) {
        var cfields, ul;
        cfields = mdl.get('Contact').CustomField;
        if (cfields) {
          ul = $('#id-ul-contact-customfields');
          ul.empty();
          _.each(cfields, function(cf) {
            var label, li, ref, value;
            label = cf.label;
            value = (ref = cf.value) != null ? ref : 'No';
            if (cf.type === 'checkbox') {
              if (value === 0) {
                value = 'No';
              } else if (value === 1) {
                value = 'Yes';
              } else {
                value = '---';
              }
            }
            if (cf.type === 'date') {
              value = Moment(cf.value).format('dddd, MMMM Do YYYY');
            }
            console.log(label, value);
            li = `<li><span class='label'>${label}</span><div class='value'>${value}</div> </li>`;
            return ul.append(li);
          });
          ul.listview();
          return ul.listview('refresh');
        }
      }

      update_note(mdl) {
        var note, nt;
        note = mdl.get('Contact').note;
        if (note) {
          nt = note.replace(/(\r\n|\n|\r)/gm, "<br>");
          return $('#id-span-contact-note').html(nt);
        }
      }

      btnCompanyClicked(event) {
        var company, companyID, view;
        event.stopPropagation();
        event.preventDefault();
        if (!CompanyView) {
          CompanyView = require("views/contact/CompanyView");
        }
        companyID = $(event.currentTarget).attr('data-companyID');
        company = new ContactModel();
        company.get_details_company(this.usr.get('sessionID'), companyID);
        view = new CompanyView(this.usr, company);
        return this.__go_to_company_view(view);
      }

      __go_to_company_view(view) {
        var index, nextView;
        nextView = _.find($.mobile.jqmNavigator.getViews(), function(view) {
          return $(view.el).attr('id') === 'id-CompanyView';
        });
        if (nextView) {
          index = _.chain($.mobile.jqmNavigator.getViews()).pluck("cid").indexOf(nextView.cid).value();
          //#console.log 'INDEX '+index
          $.mobile.jqmNavigator.getViews().splice(index, 1);
          $('#id-CompanyView').remove();
        }
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnEditContactClicked(event) {
        var view;
        event.stopPropagation();
        event.preventDefault();
        this.contactsCol.get_companies(this.usr);
        if (!FormContactView) {
          FormContactView = require("views/contact/FormContactView");
        }
        view = new FormContactView(this.usr, this.contactsCol, this.contact);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnRelatedEventsClicked(event) {
        /*
        Last true parameter is because we have the data locally storaged, and we dont need extra info from the detail_object call
        AVOIDING A NETWORK CALL
        */
        var cur, name, obj, objID, objType;
        event.preventDefault();
        event.stopPropagation();
        cur = $(event.currentTarget);
        objID = cur.attr('data-objectID');
        objType = cur.attr('data-objectType');
        obj = new ObjectModel({
          previousView: 'contactView'
        });
        obj.on('change', this.showEventList, this);
        name = this.contact.get('Contact').firstName + ' ' + this.contact.get('Contact').lastName;
        return obj.set_object_detail(this.usr, name, objID, objType, '', true);
      }

      showEventList(objMdl) {
        var ev, view;
        if (!EventCollection) {
          EventCollection = require("collections/event/EventCollection");
        }
        if (!EventListView) {
          EventListView = require("views/event/EventListView");
        }
        ev = new EventCollection();
        ev.set_day_events(this.usr, null, objMdl);
        view = new EventListView(this.usr, ev, objMdl);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

    };
  });

}).call(this);
